import { getCurrentUser } from '@/modules/auth/actions';
import { redirect, notFound } from 'next/navigation';
import { CaseService } from '@/modules/case/service';
import { CaseHeader } from '@/components/case/CaseHeader';
import { CaseDetails } from '@/components/case/CaseDetails';
import { CaseTimeline } from '@/components/case/CaseTimeline';
import { CaseNotes } from '@/components/case/CaseNotes';
import { CaseStatusManager } from '@/components/case/CaseStatusManager';

const caseService = new CaseService();

export default async function MediatorCaseDetailPage({
  params,
}: {
  params: { id: string };
}) {
  const user = await getCurrentUser();
  
  if (!user?.mediator) {
    redirect('/login');
  }

  let caseRecord;
  try {
    caseRecord = await caseService.getCaseById(params.id, user.id);
  } catch (error) {
    notFound();
  }

  return (
    <div className="max-w-6xl mx-auto">
      <CaseHeader case={caseRecord} />

      <div className="grid grid-cols-1 lg:grid-cols-3 gap-6 mt-6">
        {/* Main Content */}
        <div className="lg:col-span-2 space-y-6">
          <CaseDetails case={caseRecord} />
          <CaseTimeline timeline={caseRecord.timeline} />
        </div>

        {/* Sidebar */}
        <div className="space-y-6">
          <CaseStatusManager case={caseRecord} />
          <CaseNotes caseId={caseRecord.id} />
        </div>
      </div>
    </div>
  );
}
